/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright(c) 2021 3snic Technologies Co., Ltd */

#ifndef SSS_BOARD_INFO_H
#define SSS_BOARD_INFO_H

enum sss_board_type_define {
	SSS_BOARD_TYPE_MPU_DEFAULT		   = 0, /* Default config */
	SSS_BOARD_TYPE_TEST_EVB_4X25G		   = 1, /* EVB Board */
	SSS_BOARD_TYPE_TEST_CEM_2X100G		   = 2, /* 2X100G CEM Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X32G_FC	   = 30, /* 4X32G  SmartIO FC Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X25G_TIOE	   = 31, /* 4X25GE SmartIO TIOE Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X25G_ROCE	   = 32, /* 4X25GE SmartIO ROCE Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X25G_ROCE_AA  = 33, /* 4X25GE SmartIO ROCE_AA Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X25G_SRIOV	   = 34, /* 4X25GE SmartIO container Card */
	SSS_BOARD_TYPE_STRG_SMARTIO_4X25G_SRIOV_SW = 35, /* 4X25GE SmartIO container switch Card */
	SSS_BOARD_TYPE_STRG_2X100G_TIOE		   = 40, /* 2X100G SmartIO TIOE Card */
	SSS_BOARD_TYPE_STRG_2X100G_ROCE		   = 41, /* 2X100G SmartIO ROCE Card */
	SSS_BOARD_TYPE_STRG_2X100G_ROCE_AA	   = 42, /* 2X100G SmartIO ROCE_AA Card */
	SSS_BOARD_TYPE_CAL_2X25G_NIC_75MPPS	   = 100, /* 2X25G ETH Standard card 75MPPS */
	SSS_BOARD_TYPE_CAL_2X25G_NIC_40MPPS	   = 101, /* 2X25G ETH Standard card 40MPPS */
	SSS_BOARD_TYPE_CAL_4X25G_NIC_120MPPS	   = 105, /* 4X25G ETH Standard card 120MPPS */
	SSS_BOARD_TYPE_CAL_2X32G_FC_HBA		   = 110, /* 2X32G FC HBA card */
	SSS_BOARD_TYPE_CAL_2X16G_FC_HBA		   = 111, /* 2X16G FC HBA card */
	SSS_BOARD_TYPE_CAL_2X100G_NIC_120MPPS	   = 115, /* 2X100G ETH Standard card 120MPPS */
	SSS_BOARD_TYPE_CLD_2X100G_SDI5_1	   = 170, /* 2X100G SDI 5.1 Card */
	SSS_BOARD_TYPE_CLD_2X25G_SDI5_0_LITE	   = 171, /* 2x25G SDI5.0 Lite Card */
	SSS_BOARD_TYPE_CLD_2X100G_SDI5_0	   = 172, /* 2x100G SDI5.0 Card */
	SSS_BOARD_MAX_TYPE			   = 0xFF
};

#endif
