; NOTE: Assertions have been autogenerated by utils/update_test_checks.py

; RUN: opt < %s -passes=dse -S | FileCheck %s

target datalayout = "e-m:e-p:32:32-i64:64-v128:64:128-a:0:32-n32-S64"
declare void @unknown_func()
declare void @llvm.lifetime.start.p0(i64, ptr nocapture) nounwind
declare void @llvm.lifetime.end.p0(i64, ptr nocapture) nounwind
declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind
declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i32, i1) nounwind

declare noalias ptr @calloc(i64, i64) #5
declare noalias ptr @malloc(i64) #0
declare noalias ptr @strdup(ptr nocapture readonly) #1
declare void @free(ptr nocapture) #2

define void @test16(ptr noalias %P) {
; CHECK-LABEL: @test16(
; CHECK-NEXT:    br i1 true, label [[BB1:%.*]], label [[BB3:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    call void @free(ptr [[P:%.*]])
; CHECK-NEXT:    store i32 1, ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  store i32 1, ptr %P
  br i1 true, label %bb1, label %bb3
bb1:
  store i32 1, ptr %P
  br label %bb3
bb3:
  call void @free(ptr %P)
  store i32 1, ptr %P
  ret void
}

; We cannot remove the store in the entry block, because @unknown_func could
; unwind and the stored value could be read by the caller.
define void @test17(ptr noalias %P) {
; CHECK-LABEL: @test17(
; CHECK-NEXT:    store i32 1, ptr [[P:%.*]], align 4
; CHECK-NEXT:    br i1 true, label [[BB1:%.*]], label [[BB3:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    call void @unknown_func()
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    call void @free(ptr [[P]])
; CHECK-NEXT:    ret void
;
  store i32 1, ptr %P
  br i1 true, label %bb1, label %bb3
bb1:
  call void @unknown_func()
  store i32 1, ptr %P
  br label %bb3
bb3:
  call void @free(ptr %P)
  ret void
}

define void @test17_read_after_free(ptr noalias %P) {
; CHECK-LABEL: @test17_read_after_free(
; CHECK-NEXT:    br i1 true, label [[BB1:%.*]], label [[BB3:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    call void @free(ptr [[P:%.*]])
; CHECK-NEXT:    [[LV:%.*]] = load i8, ptr [[P]], align 1
; CHECK-NEXT:    ret void
;
  store i32 1, ptr %P
  br i1 true, label %bb1, label %bb3
bb1:
  store i32 1, ptr %P
  br label %bb3
bb3:
  call void @free(ptr %P)
  %lv = load i8, ptr %P
  ret void
}

define void @test19(ptr noalias %P) {
; CHECK-LABEL: @test19(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr inbounds i32, ptr [[P:%.*]], i64 1
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[ARRAYIDX0]], i8 0, i64 28, i1 false)
; CHECK-NEXT:    br i1 true, label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 1
; CHECK-NEXT:    store i32 1, ptr [[ARRAYIDX1]], align 4
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  call void @llvm.memset.p0.i64(ptr %arrayidx0, i8 0, i64 28, i32 4, i1 false)
  br i1 true, label %bb1, label %bb2
bb1:
  br label %bb3
bb2:
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 1, ptr %arrayidx1, align 4
  br label %bb3
bb3:
  ret void
}


define void @test20(ptr noalias %P) {
; CHECK-LABEL: @test20(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARRAYIDX0:%.*]] = getelementptr inbounds i32, ptr [[P:%.*]], i64 1
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[ARRAYIDX0]], i64 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[TMP0]], i8 0, i64 24, i1 false)
; CHECK-NEXT:    br i1 true, label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 1
; CHECK-NEXT:    store i32 1, ptr [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  call void @llvm.memset.p0.i64(ptr %arrayidx0, i8 0, i64 28, i32 4, i1 false)
  br i1 true, label %bb1, label %bb2
bb1:
  br label %bb3
bb2:
  br label %bb3
bb3:
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 1, ptr %arrayidx1, align 4
  ret void
}

define ptr @test26() {
; CHECK-LABEL: @test26(
; CHECK-NEXT:  bb1:
; CHECK-NEXT:    br i1 true, label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[M:%.*]] = call noalias ptr @malloc(i64 10)
; CHECK-NEXT:    store i8 1, ptr [[M]], align 1
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[R:%.*]] = phi ptr [ null, [[BB1:%.*]] ], [ [[M]], [[BB2]] ]
; CHECK-NEXT:    ret ptr [[R]]
;
bb1:
  br i1 true, label %bb2, label %bb3
bb2:
  %m = call noalias ptr @malloc(i64 10)
  store i8 1, ptr %m
  br label %bb3
bb3:
  %r = phi ptr [ null, %bb1 ], [ %m, %bb2 ]
  ret ptr %r
}


define void @test27() {
; CHECK-LABEL: @test27(
; CHECK-NEXT:  bb1:
; CHECK-NEXT:    br i1 true, label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[M:%.*]] = call noalias ptr @malloc(i64 10)
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[R:%.*]] = phi ptr [ null, [[BB1:%.*]] ], [ [[M]], [[BB2]] ]
; CHECK-NEXT:    ret void
;
bb1:
  br i1 true, label %bb2, label %bb3
bb2:
  %m = call noalias ptr @malloc(i64 10)
  store i8 1, ptr %m
  br label %bb3
bb3:
  %r = phi ptr [ null, %bb1 ], [ %m, %bb2 ]
  ret void
}

define ptr @test27_pointer_escape() {
; CHECK-LABEL: @test27_pointer_escape(
; CHECK-NEXT:  bb1:
; CHECK-NEXT:    br i1 true, label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[M:%.*]] = call noalias ptr @malloc(i64 10)
; CHECK-NEXT:    store i8 1, ptr [[M]], align 1
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[R:%.*]] = phi ptr [ null, [[BB1:%.*]] ], [ [[M]], [[BB2]] ]
; CHECK-NEXT:    ret ptr [[R]]
;
bb1:
  br i1 true, label %bb2, label %bb3
bb2:
  %m = call noalias ptr @malloc(i64 10)
  store i8 1, ptr %m
  br label %bb3
bb3:
  %r = phi ptr [ null, %bb1 ], [ %m, %bb2 ]
  ret ptr %r
}

define ptr @test28() {
; CHECK-LABEL: @test28(
; CHECK-NEXT:  bb0:
; CHECK-NEXT:    [[M:%.*]] = call noalias ptr @malloc(i64 10)
; CHECK-NEXT:    store i8 2, ptr [[M]], align 1
; CHECK-NEXT:    ret ptr [[M]]
;
bb0:
  %m = call noalias ptr @malloc(i64 10)
  store i8 2, ptr %m
  ret ptr %m
}

%struct.SystemCallMapElementStruct = type { ptr, i32, ptr }
%struct.NodePtrVecStruct = type { i32, i32, ptr }
%struct.NodeStruct = type { i32, i32, ptr, i32, i32, ptr, ptr, ptr, i32, i32 }
%struct.NodeListStruct = type { ptr, ptr }
%struct.EdgeListStruct = type { i32, ptr, ptr }
%struct.SystemCallMapStruct = type { i32, i32, ptr }

declare ptr @NodePtrVec_new(i32)

define noalias ptr @SystemCallMapElement_new(ptr nocapture readonly %label, i32 %initialSize) {
; CHECK-LABEL: @SystemCallMapElement_new(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call dereferenceable_or_null(24) ptr @malloc(i64 24) #[[ATTR7:[0-9]+]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq ptr [[CALL]], null
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[CLEANUP:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[CALL1:%.*]] = tail call ptr @strdup(ptr [[LABEL:%.*]])
; CHECK-NEXT:    store ptr [[CALL1]], ptr [[CALL]], align 8
; CHECK-NEXT:    [[INDEX:%.*]] = getelementptr inbounds i8, ptr [[CALL]], i64 8
; CHECK-NEXT:    store i32 -1, ptr [[INDEX]], align 8
; CHECK-NEXT:    [[TOBOOL4:%.*]] = icmp eq ptr [[CALL1]], null
; CHECK-NEXT:    br i1 [[TOBOOL4]], label [[IF_THEN5:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then5:
; CHECK-NEXT:    tail call void @free(ptr nonnull [[CALL]])
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CALL6:%.*]] = tail call ptr @NodePtrVec_new(i32 [[INITIALSIZE:%.*]]) #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    [[NODES:%.*]] = getelementptr inbounds i8, ptr [[CALL]], i64 16
; CHECK-NEXT:    store ptr [[CALL6]], ptr [[NODES]], align 8
; CHECK-NEXT:    [[TOBOOL8:%.*]] = icmp eq ptr [[CALL6]], null
; CHECK-NEXT:    br i1 [[TOBOOL8]], label [[IF_THEN9:%.*]], label [[CLEANUP]]
; CHECK:       if.then9:
; CHECK-NEXT:    tail call void @free(ptr nonnull [[CALL]])
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ null, [[IF_THEN9]] ], [ null, [[IF_THEN5]] ], [ [[CALL]], [[IF_END]] ], [ [[CALL]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret ptr [[RETVAL_0]]
;
entry:
  %call = tail call dereferenceable_or_null(24) ptr @malloc(i64 24) #4
  %tobool = icmp eq ptr %call, null
  br i1 %tobool, label %cleanup, label %if.then

if.then:                                          ; preds = %entry
  %call1 = tail call ptr @strdup(ptr %label)
  store ptr %call1, ptr %call, align 8
  %index = getelementptr inbounds i8, ptr %call, i64 8
  store i32 -1, ptr %index, align 8
  %tobool4 = icmp eq ptr %call1, null
  br i1 %tobool4, label %if.then5, label %if.end

if.then5:                                         ; preds = %if.then
  tail call void @free(ptr nonnull %call)
  br label %cleanup

if.end:                                           ; preds = %if.then
  %call6 = tail call ptr @NodePtrVec_new(i32 %initialSize) #2
  %nodes = getelementptr inbounds i8, ptr %call, i64 16
  store ptr %call6, ptr %nodes, align 8
  %tobool8 = icmp eq ptr %call6, null
  br i1 %tobool8, label %if.then9, label %cleanup

if.then9:                                         ; preds = %if.end
  tail call void @free(ptr nonnull %call)
  br label %cleanup

cleanup:                                          ; preds = %entry, %if.end, %if.then9, %if.then5
  %retval.0 = phi ptr [ null, %if.then9 ], [ null, %if.then5 ], [ %call, %if.end ], [ %call, %entry ]
  ret ptr %retval.0
}

%struct.BitfieldStruct = type { i32, ptr }

define noalias ptr @Bitfield_new(i32 %bitsNeeded) {
; CHECK-LABEL: @Bitfield_new(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call dereferenceable_or_null(16) ptr @malloc(i64 16) #[[ATTR7]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq ptr [[CALL]], null
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[CLEANUP:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[BITSNEEDED:%.*]], 7
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[ADD]], 8
; CHECK-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
; CHECK-NEXT:    [[CALL1:%.*]] = tail call ptr @calloc(i64 [[CONV]], i64 1) #[[ATTR8:[0-9]+]]
; CHECK-NEXT:    [[BITFIELD:%.*]] = getelementptr inbounds i8, ptr [[CALL]], i64 8
; CHECK-NEXT:    store ptr [[CALL1]], ptr [[BITFIELD]], align 8
; CHECK-NEXT:    [[TOBOOL3:%.*]] = icmp eq ptr [[CALL1]], null
; CHECK-NEXT:    br i1 [[TOBOOL3]], label [[IF_THEN4:%.*]], label [[IF_END5:%.*]]
; CHECK:       if.then4:
; CHECK-NEXT:    tail call void @free(ptr nonnull [[CALL]])
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       if.end5:
; CHECK-NEXT:    store i32 [[BITSNEEDED]], ptr [[CALL]], align 8
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[CALL]], [[IF_END5]] ], [ null, [[IF_THEN4]] ], [ null, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret ptr [[RETVAL_0]]
;
entry:
  %call = tail call dereferenceable_or_null(16) ptr @malloc(i64 16) #4
  %tobool = icmp eq ptr %call, null
  br i1 %tobool, label %cleanup, label %if.end

if.end:                                           ; preds = %entry
  %add = add nsw i32 %bitsNeeded, 7
  %div = sdiv i32 %add, 8
  %conv = sext i32 %div to i64
  %call1 = tail call ptr @calloc(i64 %conv, i64 1) #3
  %bitfield = getelementptr inbounds i8, ptr %call, i64 8
  store ptr %call1, ptr %bitfield, align 8
  %tobool3 = icmp eq ptr %call1, null
  br i1 %tobool3, label %if.then4, label %if.end5

if.then4:                                         ; preds = %if.end
  tail call void @free(ptr nonnull %call)
  br label %cleanup

if.end5:                                          ; preds = %if.end
  store i32 %bitsNeeded, ptr %call, align 8
  br label %cleanup

cleanup:                                          ; preds = %entry, %if.end5, %if.then4
  %retval.0 = phi ptr [ %call, %if.end5 ], [ null, %if.then4 ], [ null, %entry ]
  ret ptr %retval.0
}

attributes #0 = { nofree nounwind allocsize(0) allockind("alloc,uninitialized") }
attributes #1 = { nofree nounwind }
attributes #2 = { nounwind allockind("free") }
attributes #3 = { allocsize(0,1) }
attributes #4 = { allocsize(0) }
attributes #5 = { nofree nounwind allocsize(0,1) allockind("alloc,zeroed") }
