/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// DistributionsRpmAPIService DistributionsRpmAPI service
type DistributionsRpmAPIService service

type DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest) NestedRole(nestedRole NestedRole) DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmAddRoleExecute(r)
}

/*
DistributionsRpmRpmAddRole Method for DistributionsRpmRpmAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmAddRole(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest {
	return DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmAddRoleExecute(r DistributionsRpmAPIDistributionsRpmRpmAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmCreateRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistribution *RpmRpmDistribution
}

func (r DistributionsRpmAPIDistributionsRpmRpmCreateRequest) RpmRpmDistribution(rpmRpmDistribution RpmRpmDistribution) DistributionsRpmAPIDistributionsRpmRpmCreateRequest {
	r.rpmRpmDistribution = &rpmRpmDistribution
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmCreateExecute(r)
}

/*
DistributionsRpmRpmCreate Create a rpm distribution

Trigger an asynchronous create task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsRpmAPIDistributionsRpmRpmCreateRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmCreate(ctx context.Context) DistributionsRpmAPIDistributionsRpmRpmCreateRequest {
	return DistributionsRpmAPIDistributionsRpmRpmCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmCreateExecute(r DistributionsRpmAPIDistributionsRpmRpmCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmDistribution == nil {
		return localVarReturnValue, nil, reportError("rpmRpmDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmDeleteRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
}

func (r DistributionsRpmAPIDistributionsRpmRpmDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmDeleteExecute(r)
}

/*
DistributionsRpmRpmDelete Delete a rpm distribution

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmDeleteRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmDelete(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmDeleteRequest {
	return DistributionsRpmAPIDistributionsRpmRpmDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmDeleteExecute(r DistributionsRpmAPIDistributionsRpmRpmDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmListRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	basePath *string
	basePathContains *string
	basePathIcontains *string
	basePathIn *[]string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	repository *string
	repositoryIn *[]string
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where base_path matches value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) BasePath(basePath string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.basePath = &basePath
	return r
}

// Filter results where base_path contains value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) BasePathContains(basePathContains string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.basePathContains = &basePathContains
	return r
}

// Filter results where base_path contains value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) BasePathIcontains(basePathIcontains string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.basePathIcontains = &basePathIcontains
	return r
}

// Filter results where base_path is in a comma-separated list of values
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) BasePathIn(basePathIn []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.basePathIn = &basePathIn
	return r
}

// Number of results to return per page.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Limit(limit int32) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Name(name string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) NameContains(nameContains string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) NameIcontains(nameIcontains string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) NameIn(nameIn []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) NameStartswith(nameStartswith string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Offset(offset int32) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;base_path&#x60; - Base path * &#x60;-base_path&#x60; - Base path (descending) * &#x60;hidden&#x60; - Hidden * &#x60;-hidden&#x60; - Hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Ordering(ordering []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) PulpHrefIn(pulpHrefIn []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) PulpIdIn(pulpIdIn []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) PulpLabelSelect(pulpLabelSelect string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where repository matches value
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Repository(repository string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.repository = &repository
	return r
}

// Filter results where repository is in a comma-separated list of values
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) RepositoryIn(repositoryIn []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.repositoryIn = &repositoryIn
	return r
}

// Filter distributions based on the content served by them
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) WithContent(withContent string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Fields(fields []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) ExcludeFields(excludeFields []string) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmListRequest) Execute() (*PaginatedrpmRpmDistributionResponseList, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmListExecute(r)
}

/*
DistributionsRpmRpmList List rpm distributions

ViewSet for RPM Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsRpmAPIDistributionsRpmRpmListRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmList(ctx context.Context) DistributionsRpmAPIDistributionsRpmRpmListRequest {
	return DistributionsRpmAPIDistributionsRpmRpmListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmRpmDistributionResponseList
func (a *DistributionsRpmAPIService) DistributionsRpmRpmListExecute(r DistributionsRpmAPIDistributionsRpmRpmListRequest) (*PaginatedrpmRpmDistributionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmRpmDistributionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.basePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path", r.basePath, "")
	}
	if r.basePathContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__contains", r.basePathContains, "")
	}
	if r.basePathIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__icontains", r.basePathIcontains, "")
	}
	if r.basePathIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__in", r.basePathIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository__in", r.repositoryIn, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmListRolesRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsRpmAPIDistributionsRpmRpmListRolesRequest) Fields(fields []string) DistributionsRpmAPIDistributionsRpmRpmListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsRpmAPIDistributionsRpmRpmListRolesRequest) ExcludeFields(excludeFields []string) DistributionsRpmAPIDistributionsRpmRpmListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmListRolesExecute(r)
}

/*
DistributionsRpmRpmListRoles Method for DistributionsRpmRpmListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmListRolesRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmListRoles(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmListRolesRequest {
	return DistributionsRpmAPIDistributionsRpmRpmListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmListRolesExecute(r DistributionsRpmAPIDistributionsRpmRpmListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest) Fields(fields []string) DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest) ExcludeFields(excludeFields []string) DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmMyPermissionsExecute(r)
}

/*
DistributionsRpmRpmMyPermissions Method for DistributionsRpmRpmMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmMyPermissions(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest {
	return DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmMyPermissionsExecute(r DistributionsRpmAPIDistributionsRpmRpmMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	patchedrpmRpmDistribution *PatchedrpmRpmDistribution
}

func (r DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest) PatchedrpmRpmDistribution(patchedrpmRpmDistribution PatchedrpmRpmDistribution) DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest {
	r.patchedrpmRpmDistribution = &patchedrpmRpmDistribution
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmPartialUpdateExecute(r)
}

/*
DistributionsRpmRpmPartialUpdate Update a rpm distribution

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmPartialUpdate(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest {
	return DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmPartialUpdateExecute(r DistributionsRpmAPIDistributionsRpmRpmPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedrpmRpmDistribution == nil {
		return localVarReturnValue, nil, reportError("patchedrpmRpmDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedrpmRpmDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmReadRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsRpmAPIDistributionsRpmRpmReadRequest) Fields(fields []string) DistributionsRpmAPIDistributionsRpmRpmReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsRpmAPIDistributionsRpmRpmReadRequest) ExcludeFields(excludeFields []string) DistributionsRpmAPIDistributionsRpmRpmReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmReadRequest) Execute() (*RpmRpmDistributionResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmReadExecute(r)
}

/*
DistributionsRpmRpmRead Inspect a rpm distribution

ViewSet for RPM Distributions.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmReadRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmRead(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmReadRequest {
	return DistributionsRpmAPIDistributionsRpmRpmReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return RpmRpmDistributionResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmReadExecute(r DistributionsRpmAPIDistributionsRpmRpmReadRequest) (*RpmRpmDistributionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmDistributionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	nestedRole *NestedRole
}

func (r DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest) NestedRole(nestedRole NestedRole) DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmRemoveRoleExecute(r)
}

/*
DistributionsRpmRpmRemoveRole Method for DistributionsRpmRpmRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmRemoveRole(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest {
	return DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmRemoveRoleExecute(r DistributionsRpmAPIDistributionsRpmRpmRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsRpmAPIDistributionsRpmRpmUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsRpmAPIService
	rpmRpmDistributionHref string
	rpmRpmDistribution *RpmRpmDistribution
}

func (r DistributionsRpmAPIDistributionsRpmRpmUpdateRequest) RpmRpmDistribution(rpmRpmDistribution RpmRpmDistribution) DistributionsRpmAPIDistributionsRpmRpmUpdateRequest {
	r.rpmRpmDistribution = &rpmRpmDistribution
	return r
}

func (r DistributionsRpmAPIDistributionsRpmRpmUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsRpmRpmUpdateExecute(r)
}

/*
DistributionsRpmRpmUpdate Update a rpm distribution

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmDistributionHref
 @return DistributionsRpmAPIDistributionsRpmRpmUpdateRequest
*/
func (a *DistributionsRpmAPIService) DistributionsRpmRpmUpdate(ctx context.Context, rpmRpmDistributionHref string) DistributionsRpmAPIDistributionsRpmRpmUpdateRequest {
	return DistributionsRpmAPIDistributionsRpmRpmUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmDistributionHref: rpmRpmDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsRpmAPIService) DistributionsRpmRpmUpdateExecute(r DistributionsRpmAPIDistributionsRpmRpmUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsRpmAPIService.DistributionsRpmRpmUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_distribution_href"+"}", parameterValueToString(r.rpmRpmDistributionHref, "rpmRpmDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmDistribution == nil {
		return localVarReturnValue, nil, reportError("rpmRpmDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
