/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ExportersFilesystemExportsAPIService ExportersFilesystemExportsAPI service
type ExportersFilesystemExportsAPIService service

type ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemExportsAPIService
	filesystemExporterHref string
	filesystemExport *FilesystemExport
}

func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest) FilesystemExport(filesystemExport FilesystemExport) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest {
	r.filesystemExport = &filesystemExport
	return r
}

func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemExportsCreateExecute(r)
}

/*
ExportersCoreFilesystemExportsCreate Create a filesystem export

Trigger an asynchronous task to export files to the filesystem

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest
*/
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsCreate(ctx context.Context, filesystemExporterHref string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest {
	return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsCreateExecute(r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemExportsAPIService.ExportersCoreFilesystemExportsCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}exports/"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.filesystemExport == nil {
		return localVarReturnValue, nil, reportError("filesystemExport is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.filesystemExport
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemExportsAPIService
	filesystemFilesystemExportHref string
}

func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemExportsDeleteExecute(r)
}

/*
ExportersCoreFilesystemExportsDelete Delete a filesystem export

Endpoint for managing FilesystemExports.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemFilesystemExportHref
 @return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest
*/
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsDelete(ctx context.Context, filesystemFilesystemExportHref string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest {
	return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		filesystemFilesystemExportHref: filesystemFilesystemExportHref,
	}
}

// Execute executes the request
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsDeleteExecute(r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemExportsAPIService.ExportersCoreFilesystemExportsDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_filesystem_export_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_filesystem_export_href"+"}", parameterValueToString(r.filesystemFilesystemExportHref, "filesystemFilesystemExportHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemExportsAPIService
	filesystemExporterHref string
	limit *int32
	offset *int32
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) Limit(limit int32) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) Offset(offset int32) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest {
	r.offset = &offset
	return r
}

// A list of fields to include in the response.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) Fields(fields []string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) ExcludeFields(excludeFields []string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) Execute() (*PaginatedFilesystemExportResponseList, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemExportsListExecute(r)
}

/*
ExportersCoreFilesystemExportsList List filesystem exports

Endpoint for managing FilesystemExports.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest
*/
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsList(ctx context.Context, filesystemExporterHref string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest {
	return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return PaginatedFilesystemExportResponseList
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsListExecute(r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsListRequest) (*PaginatedFilesystemExportResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedFilesystemExportResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemExportsAPIService.ExportersCoreFilesystemExportsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}exports/"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemExportsAPIService
	filesystemFilesystemExportHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest) Fields(fields []string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest) ExcludeFields(excludeFields []string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest) Execute() (*FilesystemExportResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemExportsReadExecute(r)
}

/*
ExportersCoreFilesystemExportsRead Inspect a filesystem export

Endpoint for managing FilesystemExports.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemFilesystemExportHref
 @return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest
*/
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsRead(ctx context.Context, filesystemFilesystemExportHref string) ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest {
	return ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest{
		ApiService: a,
		ctx: ctx,
		filesystemFilesystemExportHref: filesystemFilesystemExportHref,
	}
}

// Execute executes the request
//  @return FilesystemExportResponse
func (a *ExportersFilesystemExportsAPIService) ExportersCoreFilesystemExportsReadExecute(r ExportersFilesystemExportsAPIExportersCoreFilesystemExportsReadRequest) (*FilesystemExportResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *FilesystemExportResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemExportsAPIService.ExportersCoreFilesystemExportsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_filesystem_export_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_filesystem_export_href"+"}", parameterValueToString(r.filesystemFilesystemExportHref, "filesystemFilesystemExportHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
