/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// PublicationsGemAPIService PublicationsGemAPI service
type PublicationsGemAPIService service

type PublicationsGemAPIPublicationsGemGemCreateRequest struct {
	ctx context.Context
	ApiService *PublicationsGemAPIService
	gemGemPublication *GemGemPublication
}

func (r PublicationsGemAPIPublicationsGemGemCreateRequest) GemGemPublication(gemGemPublication GemGemPublication) PublicationsGemAPIPublicationsGemGemCreateRequest {
	r.gemGemPublication = &gemGemPublication
	return r
}

func (r PublicationsGemAPIPublicationsGemGemCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PublicationsGemGemCreateExecute(r)
}

/*
PublicationsGemGemCreate Create a gem publication

Trigger an asynchronous task to publish gem content

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsGemAPIPublicationsGemGemCreateRequest
*/
func (a *PublicationsGemAPIService) PublicationsGemGemCreate(ctx context.Context) PublicationsGemAPIPublicationsGemGemCreateRequest {
	return PublicationsGemAPIPublicationsGemGemCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *PublicationsGemAPIService) PublicationsGemGemCreateExecute(r PublicationsGemAPIPublicationsGemGemCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsGemAPIService.PublicationsGemGemCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/gem/gem/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.gemGemPublication == nil {
		return localVarReturnValue, nil, reportError("gemGemPublication is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.gemGemPublication
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsGemAPIPublicationsGemGemDeleteRequest struct {
	ctx context.Context
	ApiService *PublicationsGemAPIService
	gemGemPublicationHref string
}

func (r PublicationsGemAPIPublicationsGemGemDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.PublicationsGemGemDeleteExecute(r)
}

/*
PublicationsGemGemDelete Delete a gem publication

A ViewSet for GemPublication.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param gemGemPublicationHref
 @return PublicationsGemAPIPublicationsGemGemDeleteRequest
*/
func (a *PublicationsGemAPIService) PublicationsGemGemDelete(ctx context.Context, gemGemPublicationHref string) PublicationsGemAPIPublicationsGemGemDeleteRequest {
	return PublicationsGemAPIPublicationsGemGemDeleteRequest{
		ApiService: a,
		ctx: ctx,
		gemGemPublicationHref: gemGemPublicationHref,
	}
}

// Execute executes the request
func (a *PublicationsGemAPIService) PublicationsGemGemDeleteExecute(r PublicationsGemAPIPublicationsGemGemDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsGemAPIService.PublicationsGemGemDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{gem_gem_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"gem_gem_publication_href"+"}", parameterValueToString(r.gemGemPublicationHref, "gemGemPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type PublicationsGemAPIPublicationsGemGemListRequest struct {
	ctx context.Context
	ApiService *PublicationsGemAPIService
	content *string
	contentIn *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repository *string
	repositoryVersion *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r PublicationsGemAPIPublicationsGemGemListRequest) Content(content string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r PublicationsGemAPIPublicationsGemGemListRequest) ContentIn(contentIn string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r PublicationsGemAPIPublicationsGemGemListRequest) Limit(limit int32) PublicationsGemAPIPublicationsGemGemListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r PublicationsGemAPIPublicationsGemGemListRequest) Offset(offset int32) PublicationsGemAPIPublicationsGemGemListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;pass_through&#x60; - Pass through * &#x60;-pass_through&#x60; - Pass through (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PublicationsGemAPIPublicationsGemGemListRequest) Ordering(ordering []string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreated(pulpCreated time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreatedGt(pulpCreatedGt time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreatedGte(pulpCreatedGte time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreatedLt(pulpCreatedLt time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreatedLte(pulpCreatedLte time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpHrefIn(pulpHrefIn []string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PublicationsGemAPIPublicationsGemGemListRequest) PulpIdIn(pulpIdIn []string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository referenced by HREF
func (r PublicationsGemAPIPublicationsGemGemListRequest) Repository(repository string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.repository = &repository
	return r
}

// Repository Version referenced by HREF
func (r PublicationsGemAPIPublicationsGemGemListRequest) RepositoryVersion(repositoryVersion string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// A list of fields to include in the response.
func (r PublicationsGemAPIPublicationsGemGemListRequest) Fields(fields []string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsGemAPIPublicationsGemGemListRequest) ExcludeFields(excludeFields []string) PublicationsGemAPIPublicationsGemGemListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsGemAPIPublicationsGemGemListRequest) Execute() (*PaginatedgemGemPublicationResponseList, *http.Response, error) {
	return r.ApiService.PublicationsGemGemListExecute(r)
}

/*
PublicationsGemGemList List gem publications

A ViewSet for GemPublication.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PublicationsGemAPIPublicationsGemGemListRequest
*/
func (a *PublicationsGemAPIService) PublicationsGemGemList(ctx context.Context) PublicationsGemAPIPublicationsGemGemListRequest {
	return PublicationsGemAPIPublicationsGemGemListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedgemGemPublicationResponseList
func (a *PublicationsGemAPIService) PublicationsGemGemListExecute(r PublicationsGemAPIPublicationsGemGemListRequest) (*PaginatedgemGemPublicationResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedgemGemPublicationResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsGemAPIService.PublicationsGemGemList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/publications/gem/gem/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PublicationsGemAPIPublicationsGemGemReadRequest struct {
	ctx context.Context
	ApiService *PublicationsGemAPIService
	gemGemPublicationHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PublicationsGemAPIPublicationsGemGemReadRequest) Fields(fields []string) PublicationsGemAPIPublicationsGemGemReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PublicationsGemAPIPublicationsGemGemReadRequest) ExcludeFields(excludeFields []string) PublicationsGemAPIPublicationsGemGemReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PublicationsGemAPIPublicationsGemGemReadRequest) Execute() (*GemGemPublicationResponse, *http.Response, error) {
	return r.ApiService.PublicationsGemGemReadExecute(r)
}

/*
PublicationsGemGemRead Inspect a gem publication

A ViewSet for GemPublication.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param gemGemPublicationHref
 @return PublicationsGemAPIPublicationsGemGemReadRequest
*/
func (a *PublicationsGemAPIService) PublicationsGemGemRead(ctx context.Context, gemGemPublicationHref string) PublicationsGemAPIPublicationsGemGemReadRequest {
	return PublicationsGemAPIPublicationsGemGemReadRequest{
		ApiService: a,
		ctx: ctx,
		gemGemPublicationHref: gemGemPublicationHref,
	}
}

// Execute executes the request
//  @return GemGemPublicationResponse
func (a *PublicationsGemAPIService) PublicationsGemGemReadExecute(r PublicationsGemAPIPublicationsGemGemReadRequest) (*GemGemPublicationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *GemGemPublicationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PublicationsGemAPIService.PublicationsGemGemRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{gem_gem_publication_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"gem_gem_publication_href"+"}", parameterValueToString(r.gemGemPublicationHref, "gemGemPublicationHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
