/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the AnsibleCollectionResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleCollectionResponse{}

// AnsibleCollectionResponse A serializer for Ansible Collections.
type AnsibleCollectionResponse struct {
	// The name of the Collection.
	Name string `json:"name"`
	// The namespace of the Collection.
	Namespace string `json:"namespace"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleCollectionResponse AnsibleCollectionResponse

// NewAnsibleCollectionResponse instantiates a new AnsibleCollectionResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleCollectionResponse(name string, namespace string) *AnsibleCollectionResponse {
	this := AnsibleCollectionResponse{}
	this.Name = name
	this.Namespace = namespace
	return &this
}

// NewAnsibleCollectionResponseWithDefaults instantiates a new AnsibleCollectionResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleCollectionResponseWithDefaults() *AnsibleCollectionResponse {
	this := AnsibleCollectionResponse{}
	return &this
}

// GetName returns the Name field value
func (o *AnsibleCollectionResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AnsibleCollectionResponse) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value
func (o *AnsibleCollectionResponse) GetNamespace() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionResponse) GetNamespaceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Namespace, true
}

// SetNamespace sets field value
func (o *AnsibleCollectionResponse) SetNamespace(v string) {
	o.Namespace = v
}

func (o AnsibleCollectionResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleCollectionResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["namespace"] = o.Namespace

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleCollectionResponse) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleCollectionResponse := _AnsibleCollectionResponse{}

	if err = json.Unmarshal(bytes, &varAnsibleCollectionResponse); err == nil {
		*o = AnsibleCollectionResponse(varAnsibleCollectionResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "namespace")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleCollectionResponse struct {
	value *AnsibleCollectionResponse
	isSet bool
}

func (v NullableAnsibleCollectionResponse) Get() *AnsibleCollectionResponse {
	return v.value
}

func (v *NullableAnsibleCollectionResponse) Set(val *AnsibleCollectionResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleCollectionResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleCollectionResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleCollectionResponse(val *AnsibleCollectionResponse) *NullableAnsibleCollectionResponse {
	return &NullableAnsibleCollectionResponse{value: val, isSet: true}
}

func (v NullableAnsibleCollectionResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleCollectionResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


