/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the ClientConfigurationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ClientConfigurationResponse{}

// ClientConfigurationResponse Configuration settings for the ansible-galaxy client.
type ClientConfigurationResponse struct {
	DefaultDistributionPath NullableString `json:"default_distribution_path"`
	AdditionalProperties map[string]interface{}
}

type _ClientConfigurationResponse ClientConfigurationResponse

// NewClientConfigurationResponse instantiates a new ClientConfigurationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewClientConfigurationResponse(defaultDistributionPath NullableString) *ClientConfigurationResponse {
	this := ClientConfigurationResponse{}
	this.DefaultDistributionPath = defaultDistributionPath
	return &this
}

// NewClientConfigurationResponseWithDefaults instantiates a new ClientConfigurationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewClientConfigurationResponseWithDefaults() *ClientConfigurationResponse {
	this := ClientConfigurationResponse{}
	return &this
}

// GetDefaultDistributionPath returns the DefaultDistributionPath field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ClientConfigurationResponse) GetDefaultDistributionPath() string {
	if o == nil || o.DefaultDistributionPath.Get() == nil {
		var ret string
		return ret
	}

	return *o.DefaultDistributionPath.Get()
}

// GetDefaultDistributionPathOk returns a tuple with the DefaultDistributionPath field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ClientConfigurationResponse) GetDefaultDistributionPathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.DefaultDistributionPath.Get(), o.DefaultDistributionPath.IsSet()
}

// SetDefaultDistributionPath sets field value
func (o *ClientConfigurationResponse) SetDefaultDistributionPath(v string) {
	o.DefaultDistributionPath.Set(&v)
}

func (o ClientConfigurationResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ClientConfigurationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["default_distribution_path"] = o.DefaultDistributionPath.Get()

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ClientConfigurationResponse) UnmarshalJSON(bytes []byte) (err error) {
	varClientConfigurationResponse := _ClientConfigurationResponse{}

	if err = json.Unmarshal(bytes, &varClientConfigurationResponse); err == nil {
		*o = ClientConfigurationResponse(varClientConfigurationResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "default_distribution_path")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableClientConfigurationResponse struct {
	value *ClientConfigurationResponse
	isSet bool
}

func (v NullableClientConfigurationResponse) Get() *ClientConfigurationResponse {
	return v.value
}

func (v *NullableClientConfigurationResponse) Set(val *ClientConfigurationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableClientConfigurationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableClientConfigurationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableClientConfigurationResponse(val *ClientConfigurationResponse) *NullableClientConfigurationResponse {
	return &NullableClientConfigurationResponse{value: val, isSet: true}
}

func (v NullableClientConfigurationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableClientConfigurationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


