/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the ContentAppStatusResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ContentAppStatusResponse{}

// ContentAppStatusResponse Base serializer for use with :class:`pulpcore.app.models.Model`  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
type ContentAppStatusResponse struct {
	// The name of the worker.
	Name *string `json:"name,omitempty"`
	// Timestamp of the last time the worker talked to the service.
	LastHeartbeat *time.Time `json:"last_heartbeat,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ContentAppStatusResponse ContentAppStatusResponse

// NewContentAppStatusResponse instantiates a new ContentAppStatusResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContentAppStatusResponse() *ContentAppStatusResponse {
	this := ContentAppStatusResponse{}
	return &this
}

// NewContentAppStatusResponseWithDefaults instantiates a new ContentAppStatusResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContentAppStatusResponseWithDefaults() *ContentAppStatusResponse {
	this := ContentAppStatusResponse{}
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *ContentAppStatusResponse) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ContentAppStatusResponse) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *ContentAppStatusResponse) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *ContentAppStatusResponse) SetName(v string) {
	o.Name = &v
}

// GetLastHeartbeat returns the LastHeartbeat field value if set, zero value otherwise.
func (o *ContentAppStatusResponse) GetLastHeartbeat() time.Time {
	if o == nil || IsNil(o.LastHeartbeat) {
		var ret time.Time
		return ret
	}
	return *o.LastHeartbeat
}

// GetLastHeartbeatOk returns a tuple with the LastHeartbeat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ContentAppStatusResponse) GetLastHeartbeatOk() (*time.Time, bool) {
	if o == nil || IsNil(o.LastHeartbeat) {
		return nil, false
	}
	return o.LastHeartbeat, true
}

// HasLastHeartbeat returns a boolean if a field has been set.
func (o *ContentAppStatusResponse) HasLastHeartbeat() bool {
	if o != nil && !IsNil(o.LastHeartbeat) {
		return true
	}

	return false
}

// SetLastHeartbeat gets a reference to the given time.Time and assigns it to the LastHeartbeat field.
func (o *ContentAppStatusResponse) SetLastHeartbeat(v time.Time) {
	o.LastHeartbeat = &v
}

func (o ContentAppStatusResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ContentAppStatusResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.LastHeartbeat) {
		toSerialize["last_heartbeat"] = o.LastHeartbeat
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ContentAppStatusResponse) UnmarshalJSON(bytes []byte) (err error) {
	varContentAppStatusResponse := _ContentAppStatusResponse{}

	if err = json.Unmarshal(bytes, &varContentAppStatusResponse); err == nil {
		*o = ContentAppStatusResponse(varContentAppStatusResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "last_heartbeat")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableContentAppStatusResponse struct {
	value *ContentAppStatusResponse
	isSet bool
}

func (v NullableContentAppStatusResponse) Get() *ContentAppStatusResponse {
	return v.value
}

func (v *NullableContentAppStatusResponse) Set(val *ContentAppStatusResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableContentAppStatusResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableContentAppStatusResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContentAppStatusResponse(val *ContentAppStatusResponse) *NullableContentAppStatusResponse {
	return &NullableContentAppStatusResponse{value: val, isSet: true}
}

func (v NullableContentAppStatusResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContentAppStatusResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


