/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the DebReleaseArchitecture type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebReleaseArchitecture{}

// DebReleaseArchitecture A Serializer for ReleaseArchitecture.
type DebReleaseArchitecture struct {
	// A URI of a repository the new content unit should be associated with.
	Repository *string `json:"repository,omitempty"`
	// Name of the architecture.
	Architecture string `json:"architecture"`
	// Name of the distribution.
	Distribution string `json:"distribution"`
	Codename string `json:"codename"`
	Suite string `json:"suite"`
	AdditionalProperties map[string]interface{}
}

type _DebReleaseArchitecture DebReleaseArchitecture

// NewDebReleaseArchitecture instantiates a new DebReleaseArchitecture object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebReleaseArchitecture(architecture string, distribution string, codename string, suite string) *DebReleaseArchitecture {
	this := DebReleaseArchitecture{}
	this.Architecture = architecture
	this.Distribution = distribution
	this.Codename = codename
	this.Suite = suite
	return &this
}

// NewDebReleaseArchitectureWithDefaults instantiates a new DebReleaseArchitecture object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebReleaseArchitectureWithDefaults() *DebReleaseArchitecture {
	this := DebReleaseArchitecture{}
	return &this
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *DebReleaseArchitecture) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseArchitecture) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *DebReleaseArchitecture) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *DebReleaseArchitecture) SetRepository(v string) {
	o.Repository = &v
}

// GetArchitecture returns the Architecture field value
func (o *DebReleaseArchitecture) GetArchitecture() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Architecture
}

// GetArchitectureOk returns a tuple with the Architecture field value
// and a boolean to check if the value has been set.
func (o *DebReleaseArchitecture) GetArchitectureOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Architecture, true
}

// SetArchitecture sets field value
func (o *DebReleaseArchitecture) SetArchitecture(v string) {
	o.Architecture = v
}

// GetDistribution returns the Distribution field value
func (o *DebReleaseArchitecture) GetDistribution() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value
// and a boolean to check if the value has been set.
func (o *DebReleaseArchitecture) GetDistributionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Distribution, true
}

// SetDistribution sets field value
func (o *DebReleaseArchitecture) SetDistribution(v string) {
	o.Distribution = v
}

// GetCodename returns the Codename field value
func (o *DebReleaseArchitecture) GetCodename() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Codename
}

// GetCodenameOk returns a tuple with the Codename field value
// and a boolean to check if the value has been set.
func (o *DebReleaseArchitecture) GetCodenameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Codename, true
}

// SetCodename sets field value
func (o *DebReleaseArchitecture) SetCodename(v string) {
	o.Codename = v
}

// GetSuite returns the Suite field value
func (o *DebReleaseArchitecture) GetSuite() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Suite
}

// GetSuiteOk returns a tuple with the Suite field value
// and a boolean to check if the value has been set.
func (o *DebReleaseArchitecture) GetSuiteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Suite, true
}

// SetSuite sets field value
func (o *DebReleaseArchitecture) SetSuite(v string) {
	o.Suite = v
}

func (o DebReleaseArchitecture) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebReleaseArchitecture) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	toSerialize["architecture"] = o.Architecture
	toSerialize["distribution"] = o.Distribution
	toSerialize["codename"] = o.Codename
	toSerialize["suite"] = o.Suite

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebReleaseArchitecture) UnmarshalJSON(bytes []byte) (err error) {
	varDebReleaseArchitecture := _DebReleaseArchitecture{}

	if err = json.Unmarshal(bytes, &varDebReleaseArchitecture); err == nil {
		*o = DebReleaseArchitecture(varDebReleaseArchitecture)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository")
		delete(additionalProperties, "architecture")
		delete(additionalProperties, "distribution")
		delete(additionalProperties, "codename")
		delete(additionalProperties, "suite")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebReleaseArchitecture struct {
	value *DebReleaseArchitecture
	isSet bool
}

func (v NullableDebReleaseArchitecture) Get() *DebReleaseArchitecture {
	return v.value
}

func (v *NullableDebReleaseArchitecture) Set(val *DebReleaseArchitecture) {
	v.value = val
	v.isSet = true
}

func (v NullableDebReleaseArchitecture) IsSet() bool {
	return v.isSet
}

func (v *NullableDebReleaseArchitecture) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebReleaseArchitecture(val *DebReleaseArchitecture) *NullableDebReleaseArchitecture {
	return &NullableDebReleaseArchitecture{value: val, isSet: true}
}

func (v NullableDebReleaseArchitecture) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebReleaseArchitecture) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


