/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the PackageUploadTaskResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PackageUploadTaskResponse{}

// PackageUploadTaskResponse A Serializer for responding to a package upload task.
type PackageUploadTaskResponse struct {
	Session string `json:"session"`
	Task string `json:"task"`
	TaskStartTime time.Time `json:"task_start_time"`
	AdditionalProperties map[string]interface{}
}

type _PackageUploadTaskResponse PackageUploadTaskResponse

// NewPackageUploadTaskResponse instantiates a new PackageUploadTaskResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPackageUploadTaskResponse(session string, task string, taskStartTime time.Time) *PackageUploadTaskResponse {
	this := PackageUploadTaskResponse{}
	this.Session = session
	this.Task = task
	this.TaskStartTime = taskStartTime
	return &this
}

// NewPackageUploadTaskResponseWithDefaults instantiates a new PackageUploadTaskResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPackageUploadTaskResponseWithDefaults() *PackageUploadTaskResponse {
	this := PackageUploadTaskResponse{}
	return &this
}

// GetSession returns the Session field value
func (o *PackageUploadTaskResponse) GetSession() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Session
}

// GetSessionOk returns a tuple with the Session field value
// and a boolean to check if the value has been set.
func (o *PackageUploadTaskResponse) GetSessionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Session, true
}

// SetSession sets field value
func (o *PackageUploadTaskResponse) SetSession(v string) {
	o.Session = v
}

// GetTask returns the Task field value
func (o *PackageUploadTaskResponse) GetTask() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Task
}

// GetTaskOk returns a tuple with the Task field value
// and a boolean to check if the value has been set.
func (o *PackageUploadTaskResponse) GetTaskOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Task, true
}

// SetTask sets field value
func (o *PackageUploadTaskResponse) SetTask(v string) {
	o.Task = v
}

// GetTaskStartTime returns the TaskStartTime field value
func (o *PackageUploadTaskResponse) GetTaskStartTime() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.TaskStartTime
}

// GetTaskStartTimeOk returns a tuple with the TaskStartTime field value
// and a boolean to check if the value has been set.
func (o *PackageUploadTaskResponse) GetTaskStartTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TaskStartTime, true
}

// SetTaskStartTime sets field value
func (o *PackageUploadTaskResponse) SetTaskStartTime(v time.Time) {
	o.TaskStartTime = v
}

func (o PackageUploadTaskResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PackageUploadTaskResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["session"] = o.Session
	toSerialize["task"] = o.Task
	toSerialize["task_start_time"] = o.TaskStartTime

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PackageUploadTaskResponse) UnmarshalJSON(bytes []byte) (err error) {
	varPackageUploadTaskResponse := _PackageUploadTaskResponse{}

	if err = json.Unmarshal(bytes, &varPackageUploadTaskResponse); err == nil {
		*o = PackageUploadTaskResponse(varPackageUploadTaskResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "session")
		delete(additionalProperties, "task")
		delete(additionalProperties, "task_start_time")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePackageUploadTaskResponse struct {
	value *PackageUploadTaskResponse
	isSet bool
}

func (v NullablePackageUploadTaskResponse) Get() *PackageUploadTaskResponse {
	return v.value
}

func (v *NullablePackageUploadTaskResponse) Set(val *PackageUploadTaskResponse) {
	v.value = val
	v.isSet = true
}

func (v NullablePackageUploadTaskResponse) IsSet() bool {
	return v.isSet
}

func (v *NullablePackageUploadTaskResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePackageUploadTaskResponse(val *PackageUploadTaskResponse) *NullablePackageUploadTaskResponse {
	return &NullablePackageUploadTaskResponse{value: val, isSet: true}
}

func (v NullablePackageUploadTaskResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePackageUploadTaskResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


