/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PulpImport type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PulpImport{}

// PulpImport Serializer for call to import into Pulp.
type PulpImport struct {
	// Path to export that will be imported.
	Path *string `json:"path,omitempty"`
	// Path to a table-of-contents file describing chunks to be validated, reassembled, and imported.
	Toc *string `json:"toc,omitempty"`
	// If True, missing repositories will be automatically created during the import.
	CreateRepositories *bool `json:"create_repositories,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PulpImport PulpImport

// NewPulpImport instantiates a new PulpImport object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPulpImport() *PulpImport {
	this := PulpImport{}
	var createRepositories bool = false
	this.CreateRepositories = &createRepositories
	return &this
}

// NewPulpImportWithDefaults instantiates a new PulpImport object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPulpImportWithDefaults() *PulpImport {
	this := PulpImport{}
	var createRepositories bool = false
	this.CreateRepositories = &createRepositories
	return &this
}

// GetPath returns the Path field value if set, zero value otherwise.
func (o *PulpImport) GetPath() string {
	if o == nil || IsNil(o.Path) {
		var ret string
		return ret
	}
	return *o.Path
}

// GetPathOk returns a tuple with the Path field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImport) GetPathOk() (*string, bool) {
	if o == nil || IsNil(o.Path) {
		return nil, false
	}
	return o.Path, true
}

// HasPath returns a boolean if a field has been set.
func (o *PulpImport) HasPath() bool {
	if o != nil && !IsNil(o.Path) {
		return true
	}

	return false
}

// SetPath gets a reference to the given string and assigns it to the Path field.
func (o *PulpImport) SetPath(v string) {
	o.Path = &v
}

// GetToc returns the Toc field value if set, zero value otherwise.
func (o *PulpImport) GetToc() string {
	if o == nil || IsNil(o.Toc) {
		var ret string
		return ret
	}
	return *o.Toc
}

// GetTocOk returns a tuple with the Toc field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImport) GetTocOk() (*string, bool) {
	if o == nil || IsNil(o.Toc) {
		return nil, false
	}
	return o.Toc, true
}

// HasToc returns a boolean if a field has been set.
func (o *PulpImport) HasToc() bool {
	if o != nil && !IsNil(o.Toc) {
		return true
	}

	return false
}

// SetToc gets a reference to the given string and assigns it to the Toc field.
func (o *PulpImport) SetToc(v string) {
	o.Toc = &v
}

// GetCreateRepositories returns the CreateRepositories field value if set, zero value otherwise.
func (o *PulpImport) GetCreateRepositories() bool {
	if o == nil || IsNil(o.CreateRepositories) {
		var ret bool
		return ret
	}
	return *o.CreateRepositories
}

// GetCreateRepositoriesOk returns a tuple with the CreateRepositories field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpImport) GetCreateRepositoriesOk() (*bool, bool) {
	if o == nil || IsNil(o.CreateRepositories) {
		return nil, false
	}
	return o.CreateRepositories, true
}

// HasCreateRepositories returns a boolean if a field has been set.
func (o *PulpImport) HasCreateRepositories() bool {
	if o != nil && !IsNil(o.CreateRepositories) {
		return true
	}

	return false
}

// SetCreateRepositories gets a reference to the given bool and assigns it to the CreateRepositories field.
func (o *PulpImport) SetCreateRepositories(v bool) {
	o.CreateRepositories = &v
}

func (o PulpImport) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PulpImport) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Path) {
		toSerialize["path"] = o.Path
	}
	if !IsNil(o.Toc) {
		toSerialize["toc"] = o.Toc
	}
	if !IsNil(o.CreateRepositories) {
		toSerialize["create_repositories"] = o.CreateRepositories
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PulpImport) UnmarshalJSON(bytes []byte) (err error) {
	varPulpImport := _PulpImport{}

	if err = json.Unmarshal(bytes, &varPulpImport); err == nil {
		*o = PulpImport(varPulpImport)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "path")
		delete(additionalProperties, "toc")
		delete(additionalProperties, "create_repositories")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePulpImport struct {
	value *PulpImport
	isSet bool
}

func (v NullablePulpImport) Get() *PulpImport {
	return v.value
}

func (v *NullablePulpImport) Set(val *PulpImport) {
	v.value = val
	v.isSet = true
}

func (v NullablePulpImport) IsSet() bool {
	return v.isSet
}

func (v *NullablePulpImport) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePulpImport(val *PulpImport) *NullablePulpImport {
	return &NullablePulpImport{value: val, isSet: true}
}

func (v NullablePulpImport) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePulpImport) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


