/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the UnTagImage type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UnTagImage{}

// UnTagImage A serializer for parsing and validating data associated with a manifest untagging.
type UnTagImage struct {
	// A tag name
	Tag string `json:"tag"`
	AdditionalProperties map[string]interface{}
}

type _UnTagImage UnTagImage

// NewUnTagImage instantiates a new UnTagImage object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUnTagImage(tag string) *UnTagImage {
	this := UnTagImage{}
	this.Tag = tag
	return &this
}

// NewUnTagImageWithDefaults instantiates a new UnTagImage object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUnTagImageWithDefaults() *UnTagImage {
	this := UnTagImage{}
	return &this
}

// GetTag returns the Tag field value
func (o *UnTagImage) GetTag() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Tag
}

// GetTagOk returns a tuple with the Tag field value
// and a boolean to check if the value has been set.
func (o *UnTagImage) GetTagOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Tag, true
}

// SetTag sets field value
func (o *UnTagImage) SetTag(v string) {
	o.Tag = v
}

func (o UnTagImage) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UnTagImage) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tag"] = o.Tag

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *UnTagImage) UnmarshalJSON(bytes []byte) (err error) {
	varUnTagImage := _UnTagImage{}

	if err = json.Unmarshal(bytes, &varUnTagImage); err == nil {
		*o = UnTagImage(varUnTagImage)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "tag")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableUnTagImage struct {
	value *UnTagImage
	isSet bool
}

func (v NullableUnTagImage) Get() *UnTagImage {
	return v.value
}

func (v *NullableUnTagImage) Set(val *UnTagImage) {
	v.value = val
	v.isSet = true
}

func (v NullableUnTagImage) IsSet() bool {
	return v.isSet
}

func (v *NullableUnTagImage) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUnTagImage(val *UnTagImage) *NullableUnTagImage {
	return &NullableUnTagImage{value: val, isSet: true}
}

func (v NullableUnTagImage) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUnTagImage) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


