/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the UploadResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UploadResponse{}

// UploadResponse Serializer for chunked uploads.
type UploadResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// The size of the upload in bytes.
	Size int64 `json:"size"`
	// Timestamp when upload is committed.
	Completed *time.Time `json:"completed,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _UploadResponse UploadResponse

// NewUploadResponse instantiates a new UploadResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUploadResponse(size int64) *UploadResponse {
	this := UploadResponse{}
	this.Size = size
	return &this
}

// NewUploadResponseWithDefaults instantiates a new UploadResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUploadResponseWithDefaults() *UploadResponse {
	this := UploadResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *UploadResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UploadResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *UploadResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *UploadResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *UploadResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UploadResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *UploadResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *UploadResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetSize returns the Size field value
func (o *UploadResponse) GetSize() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *UploadResponse) GetSizeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *UploadResponse) SetSize(v int64) {
	o.Size = v
}

// GetCompleted returns the Completed field value if set, zero value otherwise.
func (o *UploadResponse) GetCompleted() time.Time {
	if o == nil || IsNil(o.Completed) {
		var ret time.Time
		return ret
	}
	return *o.Completed
}

// GetCompletedOk returns a tuple with the Completed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UploadResponse) GetCompletedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.Completed) {
		return nil, false
	}
	return o.Completed, true
}

// HasCompleted returns a boolean if a field has been set.
func (o *UploadResponse) HasCompleted() bool {
	if o != nil && !IsNil(o.Completed) {
		return true
	}

	return false
}

// SetCompleted gets a reference to the given time.Time and assigns it to the Completed field.
func (o *UploadResponse) SetCompleted(v time.Time) {
	o.Completed = &v
}

func (o UploadResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UploadResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["size"] = o.Size
	if !IsNil(o.Completed) {
		toSerialize["completed"] = o.Completed
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *UploadResponse) UnmarshalJSON(bytes []byte) (err error) {
	varUploadResponse := _UploadResponse{}

	if err = json.Unmarshal(bytes, &varUploadResponse); err == nil {
		*o = UploadResponse(varUploadResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "size")
		delete(additionalProperties, "completed")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableUploadResponse struct {
	value *UploadResponse
	isSet bool
}

func (v NullableUploadResponse) Get() *UploadResponse {
	return v.value
}

func (v *NullableUploadResponse) Set(val *UploadResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableUploadResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableUploadResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUploadResponse(val *UploadResponse) *NullableUploadResponse {
	return &NullableUploadResponse{value: val, isSet: true}
}

func (v NullableUploadResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUploadResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


