/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateKeyStoreContent;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class KeyStoreFileReplaceCertificateKeyStoreContent
extends ReplaceCertificateKeyStoreContent {
    static final byte TYPE_KEY_STORE_CONTENT = -96;
    private static final byte TYPE_KEY_STORE_PATH = -120;
    private static final byte TYPE_KEY_STORE_PIN = -119;
    private static final byte TYPE_PRIVATE_KEY_PIN = -118;
    private static final byte TYPE_KEY_STORE_TYPE = -117;
    private static final byte TYPE_SOURCE_CERTIFICATE_ALIAS = -116;
    private static final long serialVersionUID = -4246144511736675823L;
    @NotNull
    private final String keyStorePath;
    @NotNull
    private final String keyStorePIN;
    @Nullable
    private final String keyStoreType;
    @Nullable
    private final String privateKeyPIN;
    @Nullable
    private final String sourceCertificateAlias;

    public KeyStoreFileReplaceCertificateKeyStoreContent(@NotNull String keyStorePath, @NotNull String keyStorePIN, @Nullable String privateKeyPIN, @Nullable String keyStoreType, @Nullable String sourceCertificateAlias) {
        Validator.ensureNotNullOrEmpty(keyStorePath, "KeyStoreFileReplaceCertificateKeyStoreContent.keyStorePath must not be null.");
        Validator.ensureNotNullOrEmpty(keyStorePIN, "KeyStoreFileReplaceCertificateKeyStoreContent.keyStorePIN must not be null.");
        this.keyStorePath = keyStorePath;
        this.keyStorePIN = keyStorePIN;
        this.privateKeyPIN = privateKeyPIN;
        this.keyStoreType = keyStoreType;
        this.sourceCertificateAlias = sourceCertificateAlias;
    }

    @NotNull
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @NotNull
    public String getKeyStorePIN() {
        return this.keyStorePIN;
    }

    @Nullable
    public String getPrivateKeyPIN() {
        return this.privateKeyPIN;
    }

    @Nullable
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Nullable
    public String getSourceCertificateAlias() {
        return this.sourceCertificateAlias;
    }

    @NotNull
    static KeyStoreFileReplaceCertificateKeyStoreContent decodeInternal(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = element.decodeAsSequence().elements();
            String keyStorePath = elements[0].decodeAsOctetString().stringValue();
            String keyStorePIN = elements[1].decodeAsOctetString().stringValue();
            String privateKeyPIN = null;
            String keyStoreType = null;
            String sourceCertificateAlias = null;
            block7: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -118: {
                        privateKeyPIN = elements[i].decodeAsOctetString().stringValue();
                        continue block7;
                    }
                    case -117: {
                        keyStoreType = elements[i].decodeAsOctetString().stringValue();
                        continue block7;
                    }
                    case -116: {
                        sourceCertificateAlias = elements[i].decodeAsOctetString().stringValue();
                    }
                }
            }
            return new KeyStoreFileReplaceCertificateKeyStoreContent(keyStorePath, keyStorePIN, privateKeyPIN, keyStoreType, sourceCertificateAlias);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_KSF_KSC_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(5);
        elements.add(new ASN1OctetString(-120, this.keyStorePath));
        elements.add(new ASN1OctetString(-119, this.keyStorePIN));
        if (this.privateKeyPIN != null) {
            elements.add(new ASN1OctetString(-118, this.privateKeyPIN));
        }
        if (this.keyStoreType != null) {
            elements.add(new ASN1OctetString(-117, this.keyStoreType));
        }
        if (this.sourceCertificateAlias != null) {
            elements.add(new ASN1OctetString(-116, this.sourceCertificateAlias));
        }
        return new ASN1Sequence(-96, elements);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("KeyStoreFileReplaceCertificateKeyStoreContent(keyStorePath='");
        buffer.append(this.keyStorePath);
        buffer.append("', privateKeyPINProvided=");
        buffer.append(this.privateKeyPIN != null);
        if (this.keyStoreType != null) {
            buffer.append(", keyStoreType='");
            buffer.append(this.keyStoreType);
            buffer.append('\'');
        }
        if (this.sourceCertificateAlias != null) {
            buffer.append(", sourceCertificateAlias='");
            buffer.append(this.sourceCertificateAlias);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

