// Copyright 2017 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#import <WatchConnectivity/WatchConnectivity.h>

#import "examples/watchos/HelloWorld/WatchSources/InterfaceController.h"

@interface InterfaceController () <WCSessionDelegate>
@end

@implementation InterfaceController

- (void)awakeWithContext:(id)context {
  [super awakeWithContext:context];

  [self.statusLabel setText:@"Waiting for greeting..."];
  [self.greetingLabel setText:@"--"];

  WCSession *session = [WCSession defaultSession];
  session.delegate = self;
  [session activateSession];
}

#pragma mark - WCSessionDelegate

- (void)session:(WCSession *)session
    didReceiveApplicationContext:(NSDictionary<NSString *,id> *)applicationContext {
  dispatch_async(dispatch_get_main_queue(), ^{
    NSString *name = (NSString *) applicationContext[@"name"];
    NSString *greeting = [NSString stringWithFormat:@"Hello, %@!", name];

    [self.statusLabel setText:@"Data received."];
    [self.greetingLabel setText:greeting];
  });
}

- (void)session:(WCSession *)session
    activationDidCompleteWithState:(WCSessionActivationState)activationState
          error:(NSError *)error {
}

- (void)sessionDidBecomeInactive:(WCSession *)session {
}

- (void)sessionDidDeactivate:(WCSession *)session {
}

@end
